//
//  UKPluginManager.h
//  PluginApp
//
//  Created by Uli Kusterer on 28.06.09.
//  Copyright 2009 The Void Software. All rights reserved.
//

/*
	Singleton that builds a list of all plugins and makes it easy to look one up.
*/

// -----------------------------------------------------------------------------
//	Headers:
// -----------------------------------------------------------------------------

#import <Cocoa/Cocoa.h>


// -----------------------------------------------------------------------------
//	UKPluginManager:
// -----------------------------------------------------------------------------

@interface UKPluginManager : NSObject
{
	NSMutableDictionary*		plugins;	// Dictionary of file extension -> NSBundle mappings.
}

+(UKPluginManager*)	sharedPluginManager;

-(NSArray*)			availablePluginExtensions;

-(Class)			pluginClassForExtension: (NSString*)fileExtension;


// private:
-(void)				loadPlugins;
-(void)				loadPluginsFromFolder: (NSString*)folderPath;

@end
