//
//  FrameworkClass.m
//  SimpleFramework
//
//  Created by Uli Kusterer on 08.09.09.
//  Copyright 2009 M. Uli Kusterer. All rights reserved.
//

#import "FrameworkClass.h"


struct FrameworkClassIVars
{
	NSString*		helloName;
	unsigned int	repetitions;
};


@implementation FrameworkClass

-(id)	init
{
	self = [super init];
	if( self )
	{
		ivars = (struct FrameworkClassIVars*) calloc( 1, sizeof(struct FrameworkClassIVars) );
	}
	
	return self;
}

-(void)	dealloc
{
	[ivars->helloName release];
	
	if( ivars )
		free( ivars );
	
	[super dealloc];
}

-(void)	setHelloName: (NSString*)theName
{
	if( ivars->helloName != theName )
	{
		[ivars->helloName release];
		ivars->helloName = [theName retain];
	}
}

-(NSString*)	helloName
{
	return ivars->helloName;
}

-(void)	sayHello
{
	NSLog(@"%u repetitions", ivars->repetitions);
	int x = 0;							// Fragile Base class test.
	for( x = 0; x < ivars->repetitions; x++ )	// Fragile Base class test.
		NSRunInformationalAlertPanel( @"Hello!", @"Having a nice day, %@?", @"OK", nil, nil, ivars->helloName );
}


-(void)			setRepetitions: (unsigned int)numReps	// Fragile Base class test.
{
	ivars->repetitions = numReps;
}

@end
