//
//  PluginAppAppDelegate.m
//  PluginApp
//
//  Created by Uli Kusterer on 28.06.09.
//  Copyright 2009 The Void Software. All rights reserved.
//

// -----------------------------------------------------------------------------
//	Headers:
// -----------------------------------------------------------------------------

#import "PluginAppAppDelegate.h"
#import "UKPluginManager.h"


@implementation PluginAppAppDelegate

@synthesize window;

// -----------------------------------------------------------------------------
//	exportUsingCurrentPlugin:
//		Action for our "Export" button that honors popup value to decide what
//		to export.
// -----------------------------------------------------------------------------

-(IBAction)	exportUsingCurrentPlugin: (id)sender
{
	NSString*				currExtension = nil;
	Class					pluginClass = Nil;
	id<PluginAppProtocol>	pluginObj = nil;
	
	currExtension = [pluginExtensionPopup titleOfSelectedItem];
	pluginClass = [[UKPluginManager sharedPluginManager] pluginClassForExtension: currExtension];
	pluginObj = (id<PluginAppProtocol>) [[[pluginClass alloc] initWithHostConnection: self] autorelease];
	
	[pluginObj exportApplicationString: [exportableField stringValue]];
}


// -----------------------------------------------------------------------------
//	pluginExtensions
//		Method so our popup menu knows what items to show.
// -----------------------------------------------------------------------------

-(NSArray*)	pluginExtensions
{
	return [[UKPluginManager sharedPluginManager] availablePluginExtensions];
}


// -----------------------------------------------------------------------------
//	showPluginMessage:
//		Simple callback method that plugins can use to talk to our app.
// -----------------------------------------------------------------------------

-(void)	showPluginMessage: (NSString*)msg
{
	NSRunAlertPanel( @"Plugin message",
				@"%@",
				@"OK", @"", @"",
				msg );
}


@end
