/* =============================================================================
    PROJECT:    Filie
    FILE:       UKFSItemController.h
    
    COPYRIGHT:  (c) 2004 by M. Uli Kusterer, all rights reserved.
    
    AUTHORS:    M. Uli Kusterer - UK
    
    LICENSES:   GNU GPL
    
    REVISIONS:
        2004-04-15  UK  Created.
   ========================================================================== */

// -----------------------------------------------------------------------------
//  Headers:
// -----------------------------------------------------------------------------

#import <Foundation/Foundation.h>


// -----------------------------------------------------------------------------
//  Classes:
// -----------------------------------------------------------------------------

@protocol UKFSItemController

+(id)			controllerForItemAtPath: (NSString*)path;
+(id)			controllerForItemAtURL: (NSURL*)path;

-(BOOL)			shouldCloseController;
-(void)			closeController;

-(void)			selectController;

-(NSString*)	displayName;
-(NSString*)	path;

-(BOOL)			isEqual: (id)other;
-(unsigned)     hash;

@end


@interface UKFSItemControllerRegistry : NSObject
{
	NSMutableDictionary*		controllers;
	NSMutableArray*				controllerInstances;
}

+(id)                       sharedRegistry;

-(void)                     registerController: (Class)vcls forType: (NSString*)type;

-(Class)                    controllerClassForType: (NSString*)type;
-(id<UKFSItemController>)   controllerForItemAtPath: (NSString*)fpath;
-(id<UKFSItemController>)   controllerForItemAtURL: (NSURL*)url;

-(void)					closeAllControllers;
-(BOOL)					canCloseAllControllers;

-(void)					memorizeOpenControllers;
-(void)					reopenMemorizedControllers;

-(void)					controllerClosed: (id<UKFSItemController>)fsiv;

@end
