/* =============================================================================
    PROJECT:    Filie
    FILE:       UKMosEisleyBar.h
    
    COPYRIGHT:  (c) 2004 by M. Uli Kusterer, all rights reserved.
    
    AUTHORS:    M. Uli Kusterer - UK
    
    LICENSES:   GNU GPL
    
    REVISIONS:
        2004-12-02  UK  Created.
   ========================================================================== */

// -----------------------------------------------------------------------------
//  Headers:
// -----------------------------------------------------------------------------

#import <Cocoa/Cocoa.h>


// -----------------------------------------------------------------------------
//  Classes:
// -----------------------------------------------------------------------------

@interface UKMosEisleyBar : NSView
{
    NSImage*        whiteLeftCap;
    NSImage*        whiteJoin;
    NSImage*        whiteBody;
    NSImage*        whiteRightCap;
    NSImage*        blueJoin;
    NSImage*        blueBody;
    NSImage*        blueRightCap;
    NSImage*        greyJoin;
    NSImage*        greyBody;
    NSImage*        greyRightCap;
    NSImage*        ltgrJoin;
    NSImage*        ltgrBody;
    NSImage*        ltgrRightCap;
    NSMutableArray* segments;
}


-(NSMutableArray*)  segments;
-(void)             setSegments: (NSMutableArray*)theSegments;


// private:
-(void) redrawUponNotification: (NSNotification*)notif;

@end
