/* =============================================================================
    PROJECT:	Etoile
	FILE:       IKIcon.h
    
    COPYRIGHT:  (c) 2004-2008 by M. Uli Kusterer, all rights reserved.
    
    AUTHORS:    M. Uli Kusterer - UK
    
    LICENSES:   GNU GPL, Modified BSD
	
	PURPOSE:	IKIcon wraps any kind of icon, kind of like an NSImage. It
				also supports combining icons in various ways to e.g. generate
				standards-conforming document icons for an application that does
				not provide any. At least that's the intention for the final
				product in Etoile. This is a Mac implementation that just
				does the basics and assumes we have an Aqua theme.
    
    REVISIONS:
        2004-12-31  UK  Created.
   ========================================================================== */

#ifndef ICONKIT_IKICON_H
#define ICONKIT_IKICON_H 1

// -----------------------------------------------------------------------------
//  Headers:
// -----------------------------------------------------------------------------

#include <AppKit/AppKit.h>
#include "IKIconIdentifier.h"
#include "IKIconPositions.h"


// -----------------------------------------------------------------------------
//  Constants:
// -----------------------------------------------------------------------------

// Notifications:
extern NSString*            IKIconChangedNotification;  // Sent with the IKIcon as the object whenever update is called.


// -----------------------------------------------------------------------------
//  Classes:
// -----------------------------------------------------------------------------

@interface IKIcon : NSObject
{
    IconRef     iconRef;        // The Carbon icon ref behind this.
    NSImage*    cachedImage;    // Cached NSImage version of this icon or for faster drawing.
    BOOL        dummy;          // Debugging flag. TRUE if this was a dummy object that we released in favor of a cached object.
}

// Convenience methods for alloc/init/autorelease:
+(id)       iconForFile: (NSString*)path;
+(id)       iconWithIdentifier: (IKIconIdentifier)identifier;
+(id)       iconWithExtension: (NSString*)suffix mimeType: (NSString*)mime
                attributes: (NSDictionary*)dict; /* any param may be NIL */
+(id)       iconWithSize: (NSSize)size;
+(id)       iconWithImage: (NSImage*)image;

// Constructors:
-(id)       initForFile: (NSString*)path;
-(id)       initWithIdentifier: (IKIconIdentifier)identifier;
-(id)       initWithExtension: (NSString*)suffix mimeType: (NSString*)mime
                attributes: (NSDictionary*)dict; /* any param may be NIL */
-(id)       initWithSize: (NSSize)size;
-(id)       initWithImage: (NSImage*)image;     // sets baseImage.
-(id)       initWithDictionary: (NSDictionary*)plist;

-(NSSize)   size;
-(NSImage*) image;

-(NSDictionary*) dictionaryRepresentation;   // For passing to initWithDictionary:.

// Compositing:
-(IKIcon*)      iconByAddingIcon: (IKIcon*)src toRect: (NSRect)pos;
-(IKIcon*)      iconByAddingIcon: (IKIcon*)src toRect: (NSRect)pos
                    operation:(NSCompositingOperation)op fraction:(float)delta;

-(NSRect)       badgeRectForPosition: (IKBadgePosition)pos;

// For theme-switching:
-(void)         update;             // Reloads the icon, possibly from the new theme.

@end


// -----------------------------------------------------------------------------
//  Prototypes:
// -----------------------------------------------------------------------------

NSString*   NSStringFromIconIdentifier( IKIconIdentifier ident );

#endif /*ICONKIT_IKICON_H*/