//
//  EpegWrapper.m
//  Epeg
//
//  Created by Marc Liyanage on Fri Jan 16 2004.
//  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
//

/*
    Modified by M. Uli Kusterer, 2004-11-17.
    
    Used to release self (in a class method!!!).
    Made this a category on NSImage.
    Made this use fileSystemRepresentation on path instead of UTF8String.
*/

#import "NSImage+Epeg.h"
#include "Epeg.h"

@implementation NSImage (Epeg)

+(NSImage*)    previewImageWithContentsOfFile:(NSString *)path boundingBox:(NSSize)boundingBox
{

	Epeg_Image *im = NULL;
	NSImage *image;
	int width_in, height_in;

	NSFileManager *fileManager = [NSFileManager defaultManager];
	BOOL isDirectory, exists;
	exists = [fileManager fileExistsAtPath:path isDirectory:&isDirectory];
	if (!exists || isDirectory)
		return nil;
	
	im = epeg_file_open( [path fileSystemRepresentation] );
	if( !im )
		return nil;

	epeg_size_get( im, &width_in, &height_in );

	float bbox_ratio = (float)(boundingBox.width / boundingBox.height);
	float orig_ratio = ((float)width_in / (float)height_in);

	float scalefactor;
	scalefactor =
		(orig_ratio > bbox_ratio)
		? (float)(boundingBox.width / width_in)
		: (float)(boundingBox.height / height_in);

	int width_out = (int)((float)width_in * scalefactor);
	int height_out = (int)((float)height_in * scalefactor);

	epeg_decode_size_set(im, width_out, height_out);
	epeg_decode_colorspace_set(im, EPEG_RGB8);

	unsigned char *outbuffer;
	int outsize;
	epeg_memory_output_set(im, &outbuffer, &outsize);
	epeg_quality_set(im, 90);
	epeg_encode(im);
	epeg_close(im);

	NSData *data = [NSData dataWithBytesNoCopy:outbuffer length:outsize];
	image = [[[NSImage alloc] initWithData:data] autorelease];
	
	if( !image )
		return nil;
	
	return image;
}

@end
