/* =============================================================================
    PROJECT:    Filie
    FILE:       UKFilieAppDelegate.m
    
    COPYRIGHT:  (c) 2004 by M. Uli Kusterer, all rights reserved.
    
    AUTHORS:    M. Uli Kusterer - UK
    
    LICENSES:   GNU GPL
    
    REVISIONS:
        2004-04-15  UK  Created.
   ========================================================================== */

// -----------------------------------------------------------------------------
//  Headers:
// -----------------------------------------------------------------------------

#import "UKFilieAppDelegate.h"
#import "UKFolderController.h"
#import "UKSidebarController.h"


@implementation UKFilieAppDelegate

// -----------------------------------------------------------------------------
//  applicationDidFinishLaunching:
//      Register our built-in controller, load the sidebar and any other controllers
//      that were open when last we quit.
//
//  REVISIONS:
//      2004-12-22  UK  Created.
// -----------------------------------------------------------------------------

-(void) applicationDidFinishLaunching: (NSNotification*)notif
{
	[[UKFSItemControllerRegistry sharedRegistry] registerController: [UKFolderController class] forType: @""];
	
	sidebar = [[UKSidebarController alloc] init];
	[sidebar selectController]; // TODO: Only do this if it was visible when last we quit!
	
	[[UKFSItemControllerRegistry sharedRegistry] reopenMemorizedControllers];
}


// -----------------------------------------------------------------------------
//  applicationWillTerminate:
//      Close all controllers after saving a list of them so we can reopen them
//      when next we start up.
//
//  REVISIONS:
//      2004-12-22  UK  Created.
// -----------------------------------------------------------------------------

-(void) applicationWillTerminate: (NSNotification*)notification
{
	[[UKFSItemControllerRegistry sharedRegistry] memorizeOpenControllers];
	
	[[UKFSItemControllerRegistry sharedRegistry] closeAllControllers];
	[sidebar closeController];
}


// -----------------------------------------------------------------------------
//  applicationShouldTerminate:
//      Ask all controllers whether they're ready to quit.
//
//  REVISIONS:
//      2004-12-22  UK  Created.
// -----------------------------------------------------------------------------

-(NSApplicationTerminateReply)  applicationShouldTerminate: (NSApplication*)sender
{
	if( [[UKFSItemControllerRegistry sharedRegistry] canCloseAllControllers]
		&& [sidebar shouldCloseController] )
		return NSTerminateNow;
	else
		return NSTerminateCancel;
}


// -----------------------------------------------------------------------------
//  orderFrontSidebar:
//      Menu item action for re-showing the sidebar if you've closed it.
//
//  REVISIONS:
//      2004-12-22  UK  Created.
// -----------------------------------------------------------------------------

-(void) orderFrontSidebar: (id)sender
{
    [sidebar selectController];
}


// -----------------------------------------------------------------------------
//  goToFolder:
//      Menu item action for "Go" menu items. Opens a controller for the specified
//      folders.
//
//  REVISIONS:
//      2004-12-22  UK  Created.
// -----------------------------------------------------------------------------

-(IBAction) goToFolder: (id<NSMenuItem>)sender
{
    NSArray*    arr = [NSArray arrayWithObjects: @"/", [@"~" stringByExpandingTildeInPath],
                                                @"/Network", @"/Applications",
                                                @"/Applications/Utilities", nil];
    NSString*   path = [arr objectAtIndex: [sender tag]];
    
    [[[UKFSItemControllerRegistry sharedRegistry] controllerForItemAtPath: path] selectController];
}

@end
