/* =============================================================================
    PROJECT:    Filie
    FILE:       UKSidebarController.m
    
    COPYRIGHT:  (c) 2004 by M. Uli Kusterer, all rights reserved.
    
    AUTHORS:    M. Uli Kusterer - UK
    
    LICENSES:   GNU GPL
    
    REVISIONS:
        2004-04-15  UK  Created.
   ========================================================================== */

// -----------------------------------------------------------------------------
//  Headers:
// -----------------------------------------------------------------------------

#import "UKSidebarController.h"
#import "UKSidebarDataSource.h"
#import "UKFolderMetaStorage.h"
#import "UKDistributedView.h"


@implementation UKSidebarController

-(id)			init
{
	self = [super initWithPath: @"/Volumes"];
	if( self )
	{
		[kqueue addPath: @"/Network"];
        [[fileListView window] setTitle: NSLocalizedString(@"Sidebar",@"Sidebar window title")];
        [self sidebarFinishCreation];
	}
	
	return self;
}


-(void) finishCreation
{

}


-(void) sidebarFinishCreation
{
    [super finishCreation];
    
    [[[NSWorkspace sharedWorkspace] notificationCenter] addObserver: self selector: @selector(volumeListChanged:) name: NSWorkspaceDidMountNotification object: nil];
    [[[NSWorkspace sharedWorkspace] notificationCenter] addObserver: self selector: @selector(volumeListChanged:) name: NSWorkspaceDidUnmountNotification object: nil];
}


-(void) volumeListChanged: (NSNotification*)notif
{
    [dataSource reload: self];
}


-(id<UKFSDataSource,NSObject>)  newDataSourceForURL: (NSURL*)url
{
    return [[UKSidebarDataSource alloc] init];
}


-(UKFolderMetaStorage*)  newMetaStorageForURL: (NSURL*)url
{
	// FIX ME! This doesn't work. Maybe this should be /Volumes?
    return [[UKFolderMetaStorage alloc] initForURL: [NSURL fileURLWithPath: [@"~/Library/Application Support/Filie/SidebarMetaStorage" stringByExpandingTildeInPath]]];
}


@end
