/* =============================================================================
    PROJECT:	Etoile
	FILE:       IKIconIdentifier.h
    
    COPYRIGHT:  (c) 2005-2008 by M. Uli Kusterer, all rights reserved.
    
    AUTHORS:    M. Uli Kusterer - UK
    
    LICENSES:   GNU GPL, Modified BSD
	
	PURPOSE:	Opaque identifier for referring to a particular icon. On the
				Mac, this is an type/creator code pair that we can pass to
				Icon Services. On other platforms, this can be anything, as long
				as it can be copied by straight assignment. Since these are all
				constants, it could be an NSString constant on GNUstep, for
				example.
				
				IKIcon.h offers functions to convert an identifier to a
				persistent string representation suitable for writing to disk
				and even passing between platforms.
    
    REVISIONS:
        2005-01-04  UK  Created.
   ========================================================================== */

#ifndef ICONKIT_IKICONIDENTIFIER_H
#define ICONKIT_IKICONIDENTIFIER_H 1

// -----------------------------------------------------------------------------
//  Headers:
// -----------------------------------------------------------------------------

#include <Foundation/Foundation.h>


// -----------------------------------------------------------------------------
//  Data Types:
// -----------------------------------------------------------------------------

typedef struct _IKIconIdentifier
{
    unsigned long      creator;     // OSType.
    unsigned long      type;        // OSType.
} IKIconIdentifier;     // Would be an NSString* on GNUstep.


// -----------------------------------------------------------------------------
//  Constants:
// -----------------------------------------------------------------------------

// Any of these can go in anywhere an IKIconIdentifier is asked:
extern IKIconIdentifier    IKIconGenericDocument;
extern IKIconIdentifier    IKIconGenericApplication;
extern IKIconIdentifier    IKIconGenericPlugIn;
extern IKIconIdentifier    IKIconGenericFolder;
extern IKIconIdentifier    IKIconPrivateFolder;
extern IKIconIdentifier    IKIconWriteOnlyFolder;
extern IKIconIdentifier    IKIconRecyclerFolder;
extern IKIconIdentifier    IKIconRecyclerFolderFull;
// ...
extern IKIconIdentifier    IKIconLinkBadge;
extern IKIconIdentifier    IKIconLockedBadge;
extern IKIconIdentifier    IKIconScriptBadge;
extern IKIconIdentifier    IKIconReadOnlyBadge;
extern IKIconIdentifier    IKIconWriteOnlyBadge;

// System icons (not for files):
extern IKIconIdentifier    IKIconAlertNote;
extern IKIconIdentifier    IKIconAlertWarning;
extern IKIconIdentifier    IKIconAlertFailure;

#endif /*ICONKIT_IKICONIDENTIFIER_H*/
