/* =============================================================================
    PROJECT:	Etoile
	FILE:       IKIcon.h
    
    COPYRIGHT:  (c) 2004-2008 by M. Uli Kusterer, all rights reserved.
    
    AUTHORS:    M. Uli Kusterer - UK
    
    LICENSES:   GNU GPL, Modified BSD
	
	PURPOSE:	Private methods for the Mac OS X implementation of IconKit.
				These methods make your code inherently platform-specific, and
				are an implementation detail that may change in the future.
				However, they're also the only way of getting the correct data
				types to pass to Carbon APIs.
    
    REVISIONS:
        2004-12-31  UK  Created.
   ========================================================================== */
#ifndef ICONKIT_IKICONPRIVATE_H
#define ICONKIT_IKICONPRIVATE_H 1

// -----------------------------------------------------------------------------
//  Headers:
// -----------------------------------------------------------------------------

#include <AppKit/AppKit.h>
#include <Carbon/Carbon.h>
#include "IKIcon.h"


// -----------------------------------------------------------------------------
//  Private header:
// -----------------------------------------------------------------------------

@interface IKIcon (IKIconMacPrivate)

// Use NSWorkspace methods instead of these:
-(id)           initWithType: (OSType)typ creator: (OSType)creator
                        extension: (NSString*)ext mimeType: (NSString*)mime;
-(id)           initWithIconRef: (IconRef)ref;  // Use this if you *must* use a Carbon API to get at your icon.

// Internal cache for more speed (you get cached icons automatically, when available, don't use these):
+(IKIcon*)      fileIconFromCache: (IconRef)theIcon;
+(void)         addIconObjectToCache: (IKIcon*)iconObj;
+(void)         removeIconFromCache: (IconRef)theIcon;

-(void)         drawInRect: (NSRect)rect;   // Use -image method and draw that instead.

-(IconRef)      iconRef;    // Use this if you need to use Carbon APIs.

@end


#endif /*ICONKIT_IKICONPRIVATE_H*/