//
//  IKIconRefImageRep.m
//  testapp
//
//  Created by Uli Kusterer on 11.02.05.
//  Copyright 2005 M. Uli Kusterer. All rights reserved.
//

#import "IKIconRefImageRep.h"
#import "IKIconPrivate.h"
#import "UKDebugNames.h"


@implementation IKIconRefImageRep

+(void) load
{
    [NSImageRep registerImageRepClass: self];
}

-(id)       initWithIcon: (IKIcon*)icn
{
    self = [super init];
    if( !self )
        return nil;
    
    icon = [icn retain];
    size = NSMakeSize(128,128);
    
    #if IKICON_DEBUG
    NSLog(@"--- IconImageRep %@ created", UKDebugNameFor(self));
    #endif
    
    return self;
}


-(void) dealloc
{
    @synchronized( self )
    {
        [icon release];
        icon = nil;

        #if IKICON_DEBUG
        NSLog(@"--- IconImageRep %@ released", UKDebugNameFor(self));
        #endif
    }
    
    [super dealloc];
}

-(BOOL) draw
{
    NSRect  box = { { 0, 0 }, { 0, 0 } };
    box.size = size;
    
    [icon drawInRect: box];
    
    return YES;
}


-(BOOL) drawAtPoint: (NSPoint)point
{
    NSRect  box;
    box.origin = point;
    box.size = size;
    
    [icon drawInRect: box];
    
    return YES;
}

-(BOOL) drawInRect: (NSRect)rect
{
    [icon drawInRect: rect];
    
    return YES;
}

-(BOOL) hasAlpha
{
    return YES;
}


-(BOOL) isOpaque
{
    return NO;
}


-(NSString*)    colorSpaceName
{
    return NSDeviceRGBColorSpace;
}


-(int)  bitsPerSample
{
    return 32;
}

-(int)  pixelsWide
{
    return [icon size].width;
}

-(int)  pixelsHigh
{
    return [icon size].height;
}

-(NSSize)   size
{
    return size;
}

-(void) setSize: (NSSize)sz
{
    size = sz;
}

// We may want to fix the following three to eventually import 'icns' data:
+(BOOL) canInitWithData: (NSData*)data
{
    return NO;
}


+(NSArray*) imageUnfilteredFileTypes
{
    return [NSArray array];
}


+(NSArray*) imageUnfilteredPasteboardTypes
{
    return [NSArray array];
}


-(IKIcon*)  icon
{
    return icon;
}


@end
