/* =============================================================================
    PROJECT:	Etoile
	FILE:       IKWorkspaceAdditions.h
    
    COPYRIGHT:  (c) 2005-2008 by M. Uli Kusterer, all rights reserved.
    
    AUTHORS:    M. Uli Kusterer - UK
    
    LICENSES:   GNU GPL, Modified BSD
	
	PURPOSE:	Methods that IconKit provides in NSWorkspace. Currently
				unimplemented on the Mac, as we'd need to override the ones that
				are already in NSWorkspace there.
    
    REVISIONS:
        2005-01-04  UK  Created.
   ========================================================================== */

#ifndef ICONKIT_IKWORKSPACEADDITIONS_H
#define ICONKIT_IKWORKSPACEADDITIONS_H 1

// -----------------------------------------------------------------------------
//  Headers:
// -----------------------------------------------------------------------------

#include <AppKit/AppKit.h>


// -----------------------------------------------------------------------------
//  Categories:
// -----------------------------------------------------------------------------

@interface NSWorkspace (IKIconAdditions)

-(NSImage*) iconForFile: (NSString*)fullPath;
-(NSImage*) iconForFiles: (NSArray*)fullPaths;
-(NSImage*) iconForFileType: (NSString*)fileType;

@end


#endif /*ICONKIT_IKWORKSPACEADDITIONS_H*/
