/* =============================================================================
    PROJECT:    Filie
    FILE:       UKMosEisleyBar.m
    
    COPYRIGHT:  (c) 2004 by M. Uli Kusterer, all rights reserved.
    
    AUTHORS:    M. Uli Kusterer - UK
    
    LICENSES:   GNU GPL
    
    REVISIONS:
        2004-12-02  UK  Created.
   ========================================================================== */

// -----------------------------------------------------------------------------
//  Headers:
// -----------------------------------------------------------------------------

#import "UKMosEisleyBar.h"
#include <time.h>


@implementation UKMosEisleyBar

// -----------------------------------------------------------------------------
//  initWithFrame:
//      Designated initializer. Loads all images we might need for
//      active/inactive/aqua/graphite and initializes the segments of this view
//      with a default width.
//
//      TODO: We should probably load the segments dictionary from a .plist file
//      to make it easier to customize. Or better, we may want to create an
//      IBPalette for this critter and implement NSCoding constructors so the
//      segments can be set up in IB/Gorm.
//
//  REVISIONS:
//      2004-12-22  UK  Documented.
// -----------------------------------------------------------------------------

-(id)   initWithFrame: (NSRect)frame
{
    self = [super initWithFrame:frame];
    if( self )
    {
        whiteLeftCap = [[NSImage imageNamed: @"moseisleybar01"] retain];
        whiteJoin = [[NSImage imageNamed: @"moseisleybar02"] retain];
        whiteBody = [[NSImage imageNamed: @"moseisleybar03"] retain];
        whiteRightCap = [[NSImage imageNamed: @"moseisleybar04"] retain];
        blueJoin = [[NSImage imageNamed: @"moseisleybar12"] retain];
        blueBody = [[NSImage imageNamed: @"moseisleybar13"] retain];
        blueRightCap = [[NSImage imageNamed: @"moseisleybar14"] retain];
        greyJoin = [[NSImage imageNamed: @"moseisleybar22"] retain];
        greyBody = [[NSImage imageNamed: @"moseisleybar23"] retain];
        greyRightCap = [[NSImage imageNamed: @"moseisleybar24"] retain];
        ltgrJoin = [[NSImage imageNamed: @"moseisleybar32"] retain];
        ltgrBody = [[NSImage imageNamed: @"moseisleybar33"] retain];
        ltgrRightCap = [[NSImage imageNamed: @"moseisleybar34"] retain];
        
        segments = [[NSMutableArray arrayWithObjects:
                        [NSDictionary dictionaryWithObjectsAndKeys:
                            [NSNumber numberWithFloat:59], @"width",
                            @"white", @"color", nil
                        ],
                        [NSDictionary dictionaryWithObjectsAndKeys:
                            [NSNumber numberWithFloat:25], @"width",
                            @"white", @"color", nil
                        ],
                        [NSDictionary dictionaryWithObjectsAndKeys:
                            [NSNumber numberWithFloat: -206], @"width",
                            @"white", @"color", nil
                        ],
                        [NSDictionary dictionaryWithObjectsAndKeys:
                            [NSNumber numberWithFloat: 0], @"width",
                            @"blue", @"color", nil
                        ],
                        nil] retain];
        
    }
    return self;
}


// -----------------------------------------------------------------------------
//  awakeFromNib:
//      Here we register for the notifications that tell us to change our look.
//      In particular for the user changing control tint, and for our window's
//      activity changes.
//
//      FIX ME! Should move this into viewMovedToWindow: or whatever it's
//      called. Otherwise manually-created views of this kind won't register.
//
//  REVISIONS:
//      2004-12-22  UK  Documented.
// -----------------------------------------------------------------------------

-(void) awakeFromNib
{
    //[super awakeFromNib];
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                        selector:@selector(redrawUponNotification:)
                                        name:NSControlTintDidChangeNotification
                                        object: nil];
    [[NSNotificationCenter defaultCenter] addObserver:self
                                        selector:@selector(redrawUponNotification:)
                                        name:NSWindowDidBecomeMainNotification
                                        object: [self window]];
    [[NSNotificationCenter defaultCenter] addObserver:self
                                        selector:@selector(redrawUponNotification:)
                                        name:NSWindowDidResignMainNotification
                                        object: [self window]];
}


// ---------------------------------------------------------- 
//  - dealloc:
// ---------------------------------------------------------- 
- (void) dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver: self];

    [whiteLeftCap release];
    [whiteJoin release];
    [whiteBody release];
    [whiteRightCap release];
    [blueJoin release];
    [blueBody release];
    [blueRightCap release];
    [greyJoin release];
    [greyBody release];
    [greyRightCap release];
    [ltgrJoin release];
    [ltgrBody release];
    [ltgrRightCap release];
    [segments release];

    whiteLeftCap = nil;
    whiteJoin = nil;
    whiteBody = nil;
    whiteRightCap = nil;
    blueJoin = nil;
    blueBody = nil;
    blueRightCap = nil;
    greyJoin = nil;
    greyBody = nil;
    greyRightCap = nil;
    
    [super dealloc];
}


// -----------------------------------------------------------------------------
//  drawRect:
//      Draw the view, including all of its segments.
//
//  REVISIONS:
//      2004-12-22  UK  Documented.
// -----------------------------------------------------------------------------

-(void) drawRect: (NSRect)rect
{
    NSRect          box = { { 0, 0 }, { 0, 0 } };
    NSEnumerator*   enny = [segments objectEnumerator];
    NSDictionary*   currSegment;
    NSControlTint   tint = [NSColor currentControlTint];
    NSImage*        colorJoin = (tint == NSGraphiteControlTint) ? greyJoin : blueJoin;
    NSImage*        colorBody = (tint == NSGraphiteControlTint) ? greyBody : blueBody;
    NSImage*        colorRightCap = (tint == NSGraphiteControlTint) ? greyRightCap : blueRightCap;
    NSImage*        bodyImg = nil;
    NSImage*        joinImg = nil;
    NSImage*        capImg = whiteRightCap;
    
    if( ![[self window] isMainWindow] )  // isKeyWindow ?
    {
        colorJoin = ltgrJoin;
        colorBody = ltgrBody;
        colorRightCap = ltgrRightCap;
    }
    
    box.size = [whiteLeftCap size];
    box.origin.y = [self bounds].size.height -box.size.height;
    
    // Draw left edge:
    [whiteLeftCap dissolveToPoint: box.origin fraction: 1.0];
    box.origin.x += box.size.width;
    
    // Now draw segments:
    while( (currSegment = [enny nextObject]) )
    {
        float segSize = [[currSegment objectForKey: @"width"] floatValue];
        if( segSize > 0 )
            box.size.width = segSize;
        else
            box.size.width = [self bounds].size.width -box.origin.x +segSize;
        if( ![[currSegment objectForKey: @"color"] isEqualToString: @"white"] )
        {
            joinImg = colorJoin;
            bodyImg = colorBody;
            capImg = colorRightCap;
        }
        else
        {
            if( bodyImg == whiteBody )
                joinImg = whiteJoin;
            else
                joinImg = nil;
            bodyImg = whiteBody;
            capImg = whiteRightCap;
        }
        
        NSRect  imgBox = { {0,0}, {0,0} };
        imgBox.size = [bodyImg size];
        
        // Draw join:
        if( joinImg )   // This isn't the first one, which doesn't get a join.
        {
            [joinImg dissolveToPoint: box.origin fraction: 1.0];
            box.origin.x += [joinImg size].width;
            box.size.width -= [joinImg size].width;
        }
        
        // Draw body:
        [bodyImg drawInRect: box fromRect:imgBox operation:NSCompositeCopy fraction: 1.0];
        box.origin.x += box.size.width;
    }
    
    // Draw right edge:
    box.origin.x = [self bounds].size.width -[capImg size].width;
    [capImg dissolveToPoint: box.origin fraction: 1.0];
    
    // Easter egg:
    time_t		vTime;
    struct tm*	vTm;
    
    vTime = time(NULL);
    vTm = localtime( &vTime );
    
    if( (vTm->tm_mon +1) == 4 && vTm->tm_mday == 1 )
    {
        NSImage*    img = [NSImage imageNamed: @"moseisleybar45"];
        NSPoint     pos = { 0,0 };
        pos.x = truncf(([self bounds].size.width -[img size].width) /2);
        pos.y = [self bounds].size.height -[img size].height;
        [img dissolveToPoint: pos fraction: 0.7];
    }
}

// ---------------------------------------------------------- 
// - segments:
// ---------------------------------------------------------- 
- (NSMutableArray *) segments
{
    return segments; 
}

// ---------------------------------------------------------- 
// - setSegments:
// ---------------------------------------------------------- 
- (void) setSegments: (NSMutableArray *) theSegments
{
    if (segments != theSegments) {
        [segments release];
        segments = [theSegments retain];
        [self setNeedsDisplay: YES];
    }
}


// -----------------------------------------------------------------------------
//  redrawUponNotification:
//      All notifications (tint change, window activity change) call this
//      method to cause an appropriate change in display style.
//
//  REVISIONS:
//      2004-12-22  UK  Documented.
// -----------------------------------------------------------------------------

-(void) redrawUponNotification: (NSNotification*)notif
{
    [self setNeedsDisplay: YES];
}

@end
