//
//  UKTiledImageView.m
//  TalkingMoose
//
//  Created by Uli Kusterer on 03.02.05.
//  Copyright 2005 M. Uli Kusterer. All rights reserved.
//

#import "UKTiledImageView.h"


@implementation UKTiledImageView

- (id)initWithFrame:(NSRect)frame {
    self = [super initWithFrame:frame];
    if( self )
    {
        // Initialization code here.
    }
    return self;
}

-(void) drawRect:(NSRect)rect
{
    NSImage*    img = [self image];
    NSRect      dstBox = { { 0, 0 }, { 0, 0 } },
                srcBox = { { 0, 0 }, { 0, 0 } };
    float       xend = [self bounds].size.width;
    
    dstBox.size = srcBox.size = [img size];
    
    while( dstBox.origin.x <= xend )
    {
        [img drawInRect: dstBox fromRect: srcBox operation: NSCompositeCopy fraction: 1.0];
        dstBox.origin.x += dstBox.size.width;
    }
}

@end
