/* =============================================================================
    PROJECT:    Filie
    FILE:       UKFileInfoPanel.h
    
    COPYRIGHT:  (c) 2004 by M. Uli Kusterer, all rights reserved.
    
    AUTHORS:    M. Uli Kusterer - UK
    
    LICENSES:   GNU GPL
    
    REVISIONS:
        2004-12-09  UK  Created.
   ========================================================================== */

// -----------------------------------------------------------------------------
//  Headers:
// -----------------------------------------------------------------------------

#import <Cocoa/Cocoa.h>
#import "UKNibOwner.h"
#import "UKFileInfoProtocol.h"


// -----------------------------------------------------------------------------
//  Classes:
// -----------------------------------------------------------------------------

@interface UKFileInfoPanel : UKNibOwner <UKFileInfoProtocol>
{
    NSMutableArray*         delegates;
    NSMutableDictionary*    fileAttributes;
    BOOL                    isMultipleSelection;
    IBOutlet NSTableView*   attributesTable;
    IBOutlet NSTextField*   osTypeField;
    IBOutlet NSTextField*   osCreatorField;
    IBOutlet NSTextField*   sizeField;
    IBOutlet NSPopUpButton* labelPopUp;
}

-(void) osTypeFieldChanged: (id)sender;
-(void) osCreatorFieldChanged: (id)sender;

-(void) labelPopUpChanged: (id)sender;

// Inherited from UKFileInfoProtocol: (needed here so IB picks them up)
-(IBAction) revert: (id)sender;
-(IBAction) ok: (id)sender;

@end
