/* =============================================================================
    PROJECT:	Etoile
	FILE:       IKIconRefImageRep.h
    
    COPYRIGHT:  (c) 2005-2008 by M. Uli Kusterer, all rights reserved.
    
    AUTHORS:    M. Uli Kusterer - UK
    
    LICENSES:   GNU GPL, Modified BSD
	
	PURPOSE:	Mac-specific image rep. This class can be used to add any
				IconRef to an NSImage without having to convert it to an NSImage
				first. This provides a moderate speed-up on Mac, where IconRefs
				already draw very fast and scale beautifully, by just calling
				upon the IKIcon to do the work.
    
    REVISIONS:
        2005-02-11  UK  Created.
   ========================================================================== */

// -----------------------------------------------------------------------------
//  Headers:
// -----------------------------------------------------------------------------

#import <Cocoa/Cocoa.h>
#import "IKIcon.h"


// -----------------------------------------------------------------------------
//  Image representation class for use in NSImage:
// -----------------------------------------------------------------------------

@interface IKIconRefImageRep : NSImageRep
{
    IKIcon*     icon;   // The actual image that takes care of drawing.
    NSSize      size;   // The size to draw this rep at.
}

-(id)       initWithIcon: (IKIcon*)icn;

-(IKIcon*)  icon;

@end
