//
//  UKSpeechSettingsView.h
//  CocoaMoose
//
//  Created by Uli Kusterer on Mon Apr 05 2004.
//  Copyright (c) 2004 M. Uli Kusterer. All rights reserved.
//

#import <Foundation/Foundation.h>


@class UKSpeechSynthesizer;

@interface UKSpeechSettingsView : NSView
{
	IBOutlet NSView*		mainView;
	IBOutlet NSTextView*	demoText;
	IBOutlet NSPopUpButton* voicePopup;
	IBOutlet NSTextField*   ageField;
	IBOutlet NSTextField*   genderField;
	IBOutlet NSTextField*   volumeField;
	IBOutlet NSTextField*   pitchField;
	IBOutlet NSTextField*   rateField;
	IBOutlet NSStepper*		volumeStepper;
	IBOutlet NSStepper*		pitchStepper;
	IBOutlet NSStepper*		rateStepper;
	UKSpeechSynthesizer*	speechSynthesizer;
}

-(IBAction) voiceChanged: (id)sender;
-(IBAction) testSpeak: (id)sender;
-(IBAction) pitchChanged: (id)sender;
-(IBAction) volumeChanged: (id)sender;
-(IBAction) rateChanged: (id)sender;

-(UKSpeechSynthesizer *)	speechSynthesizer;
-(void)	setSpeechSynthesizer: (UKSpeechSynthesizer *)newSpeechSynthesizer;

// private:
-(void) reflectVoiceInUI: (id)sender;

@end

#if MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_3
@interface NSSpeechSynthesizer (UKSpeechSettings)

-(NSDictionary*)	settingsDictionary;
-(void)				setSettingsDictionary: (NSDictionary*)dict;

@end
#endif

