//
//  UKSpeechSettingsView.m
//  CocoaMoose
//
//  Created by Uli Kusterer on Mon Apr 05 2004.
//  Copyright (c) 2004 M. Uli Kusterer. All rights reserved.
//

#import "UKSpeechSettingsView.h"
#import "UKSpeechSynthesizer.h"

// These are here so we don't have to pull in UKSpeechSynthesizer
@interface NSObject (UKSpeechSynthExtensions)

-(void)				setSpeechVolume: (short)n;
-(short)			speechVolume;

-(void)				setSpeechPitch: (double)pitch;
-(double)			speechPitch;

-(void)				setSpeechRate: (unsigned short)n;
-(unsigned short)	speechRate;

@end


@implementation UKSpeechSettingsView

-(void) awakeFromNib
{
	static BOOL		isAwaking = NO;
	NSPoint			pos = { 0, 0 };
	
	if( !isAwaking )
	{
		isAwaking = YES;
		[NSBundle loadNibNamed: @"UKSpeechSettingsView" owner: self];
		pos.y += [self frame].size.height -[mainView frame].size.height;
		[mainView setFrameOrigin: pos];
		[self addSubview: mainView];
		[mainView setAutoresizingMask: NSViewWidthSizable | NSViewMinXMargin | NSViewMaxXMargin | NSViewMinYMargin];
		
		[voicePopup removeAllItems];
		NSEnumerator*		enny = [[UKSpeechSynthesizer availableVoices] objectEnumerator];
		NSString*			voiceID = nil;
		while( (voiceID = [enny nextObject]) )
		{
			[voicePopup addItemWithTitle: [[UKSpeechSynthesizer attributesForVoice: voiceID] objectForKey: NSVoiceName]];
		}
		if( speechSynthesizer )
			[self reflectVoiceInUI: nil];
		isAwaking = NO;
	}
}

-(void) dealloc
{
	[mainView release];
	[speechSynthesizer release];
	
	[super dealloc];
}


-(IBAction) voiceChanged: (id)sender
{
	NSString*		currVoice = [[UKSpeechSynthesizer availableVoices] objectAtIndex: [voicePopup indexOfSelectedItem]];
	[speechSynthesizer setVoice: currVoice];
	[self reflectVoiceInUI: nil];
}

-(IBAction) pitchChanged: (id)sender
{
	[speechSynthesizer setSpeechPitch: [pitchStepper doubleValue]];
	[pitchField setDoubleValue: [pitchStepper doubleValue]];
}


-(IBAction) volumeChanged: (id)sender
{
	[speechSynthesizer setSpeechVolume: [volumeStepper intValue]];
	[volumeField setIntValue: [volumeStepper intValue]];
}


-(IBAction) rateChanged: (id)sender
{
	[speechSynthesizer setSpeechRate: [rateStepper intValue]];
	[rateField setIntValue: [rateStepper intValue]];
}


-(void) reflectVoiceInUI: (id)sender
{
	NSDictionary*   attrs = [UKSpeechSynthesizer attributesForVoice: [speechSynthesizer voice]];
	if( attrs == nil )
		attrs = [UKSpeechSynthesizer attributesForVoice: UK_SPEECH_VOICE_PREFIX "Fred"];
	NSString*		demoTextStr = [attrs objectForKey: NSVoiceDemoText];
	if( !demoTextStr )
		demoTextStr = @"Some nit didn't provide a demo text for this voice.";
	[demoText setString: demoTextStr];
	NSString*		currName = [attrs objectForKey: NSVoiceName];
	if( currName )
		[voicePopup selectItemWithTitle: currName];
	NSString*		gender = [attrs objectForKey: NSVoiceGender];
	if( [gender isEqualToString: NSVoiceGenderNeuter] )
		gender = @"Neuter";
	else if( [gender isEqualToString: NSVoiceGenderMale] )
		gender = @"Male";
	else if( [gender isEqualToString: NSVoiceGenderFemale] )
		gender = @"Female";
	[genderField setStringValue: NSLocalizedString( gender, @"" ) ];
	[ageField setObjectValue: [attrs objectForKey: NSVoiceAge]];
	
	if( [speechSynthesizer respondsToSelector: @selector(speechPitch)] )
	{
		[pitchField setDoubleValue: [speechSynthesizer speechPitch]];
		[pitchStepper setDoubleValue: [pitchField doubleValue]];
		[volumeField setIntValue: [speechSynthesizer speechVolume]];
		[volumeStepper setDoubleValue: [volumeField intValue]];
		[rateField setIntValue: [speechSynthesizer speechRate]];
		[rateStepper setDoubleValue: [rateField intValue]];
	}
	else
	{
		[pitchField removeFromSuperview];
		pitchField = nil;
		[volumeField removeFromSuperview];
		volumeField = nil;
		[rateField removeFromSuperview];
		rateField = nil;
		[pitchStepper removeFromSuperview];
		pitchStepper = nil;
		[volumeStepper removeFromSuperview];
		volumeStepper = nil;
		[rateStepper removeFromSuperview];
		rateStepper = nil;
	}
}


-(IBAction) testSpeak: (id)sender
{
	[speechSynthesizer startSpeakingString: [demoText string]];
}


-(UKSpeechSynthesizer *)	speechSynthesizer
{
    return speechSynthesizer;
}

-(void)	setSpeechSynthesizer: (UKSpeechSynthesizer *)newSpeechSynthesizer
{
    if( speechSynthesizer != newSpeechSynthesizer )
	{
		[speechSynthesizer release];
		speechSynthesizer = [newSpeechSynthesizer retain];
		
		[self reflectVoiceInUI: nil];
	}
}

@end


#if MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_3

@implementation NSSpeechSynthesizer (UKSpeechSettings)

-(NSDictionary*)	settingsDictionary
{
	NSMutableDictionary*		dict = [NSMutableDictionary dictionary];
	
	[dict setObject: [self voice] forKey: @"voice"];
	[dict setObject: [NSNumber numberWithInt: [self usesFeedbackWindow]] forKey: @"usesFeedbackWindow"];
	
	return dict;
}


-(void)				setSettingsDictionary: (NSDictionary*)dict
{
	[self setVoice: [dict objectForKey: @"voice"]];
	[self setUsesFeedbackWindow: [[dict objectForKey: @"usesFeedbackWindow"] boolValue]];
}

@end

#endif
