//
//  MyDocument.h
//  UKTurboExport
//
//  Created by Uli Kusterer on 09.02.08.
//  Copyright 2008 M. Uli Kusterer. All rights reserved.
//

/*
	This is a document class that opens a QuickTime movie and exports it to
	H.264 using the Turbo.264 device.
	
	This code is roughly inspired by Apple's QTKitThreadedExport sample code.
*/

// -----------------------------------------------------------------------------
//	Headers:
// -----------------------------------------------------------------------------

#import <QTKit/QTKit.h>


// -----------------------------------------------------------------------------
//	Headers:
// -----------------------------------------------------------------------------

@interface MyDocument : NSDocument
{
	IBOutlet QTMovieView*			movieView;		// So the user can play with the movie a bit.
	IBOutlet NSProgressIndicator*	progress;		// Progress indicator so the user knows we're working for her.
	IBOutlet NSPopUpButton*			presetPopup;	// Popup for picking an export preset.
	IBOutlet NSButton*				exportButton;	// Start an export.
}

-(IBAction)	exportMovie: (id)sender;

@end
