//
//  PBXApplicationTarget.m
//  VerpackIt
//
//	THIS IS AN OLD-STYLE (Project Builder) target. Use PBXNativeTarget instead
//		for xCode-style targets!
//
//  Created by Uli Kusterer on 15.09.04.
//  Copyright 2004 M. Uli Kusterer. All rights reserved.
//

#import "PBXApplicationTarget.h"


@implementation PBXApplicationTarget

-(id)	initWithObjData: (NSDictionary*)objData archive: (PBXArchive*)arc
{
	self = [super init];
	if( self )
	{
		objectData = [objData retain];
		buildPhases = [[NSMutableArray alloc] init];
		dependencies = [[NSMutableArray alloc] init];
		
		//NSLog(@"\n********** %@ **********\n%@\n ---------- %@ ----------\n", NSStringFromClass([self class]), objectData,NSStringFromClass([self class]));

		// Build Phases:
		NSEnumerator*	enny = [[objData objectForKey: @"buildPhases"] objectEnumerator];
		NSString*		objName;
		id				obj;
		
		while( (objName = [enny nextObject]) )
		{
			obj = [arc inflateObject: objName];
			if( obj ) [buildPhases addObject: obj];
		}
		
		// Dependencies:
		enny = [[objData objectForKey: @"dependencies"] objectEnumerator];
		
		while( (objName = [enny nextObject]) )
		{
			obj = [arc inflateObject: objName];
			if( obj ) [dependencies addObject: obj];
		}
		
		// product reference:
		productReference = [[arc inflateObject: [objData objectForKey: @"productReference"]] retain];
		productSettingsXML = [[objData objectForKey: @"productSettingsXML"] retain];
		productInstallPath = [[objData objectForKey: @"productInstallPath"] retain];
		productName = [[objData objectForKey: @"productName"] retain];
		buildSettings = [[objData objectForKey: @"buildSettings"] retain];
		name = [[objData objectForKey: @"name"] retain];
		//NSLog(@"--------------------\n%@\n\n",buildSettings);
	}
	
	return self;
}


-(void) dealloc
{
	[objectData release];
	objectData = nil;

 	[name release];
	name = nil;
 
	[buildPhases release];
	buildPhases = nil;

	[buildSettings release];
	buildSettings = nil;

	[dependencies release];
	dependencies = nil;

 	[productReference release];
	productReference = nil;

 	[productSettingsXML release];
	productSettingsXML = nil;

 	[productInstallPath release];
	productInstallPath = nil;

	[productName release];
	productName = nil;

   [super dealloc];
}

-(NSString*)	description
{
	return [NSString stringWithFormat: @"%@ { name = %@, productInstallPath = %@, productName = %@, buildSettings = %@, productSettingsXML = %@ }",
						NSStringFromClass([self class]),
						name, productInstallPath, productName, buildSettings, productSettingsXML];
}


-(int)						count
{
	return 1 +[buildPhases count] +[dependencies count];
}

-(id)	objectAtIndex: (int)n
{
	if( n == 0 )
		return productReference;
	else if( n <= [buildPhases count] )
		return [buildPhases objectAtIndex: (n -1)];
	else
		return [dependencies objectAtIndex: (n -1 -[buildPhases count])];
}


// ---------------------------------------------------------- 
// - productReference:
// ---------------------------------------------------------- 
- (id) productReference
{
    return productReference; 
}


// ---------------------------------------------------------- 
// - productSettingsXML:
// ---------------------------------------------------------- 
- (NSString *) productSettingsXML
{
    return productSettingsXML; 
}


// ---------------------------------------------------------- 
// - productName:
// ---------------------------------------------------------- 
- (NSString *) productName
{
    return productName; 
}


// ---------------------------------------------------------- 
// - productInstallPath:
// ---------------------------------------------------------- 
- (NSString *) productInstallPath
{
    return productInstallPath; 
}


// ---------------------------------------------------------- 
// - name:
// ---------------------------------------------------------- 
- (NSString *) name
{
    return name; 
}

// ---------------------------------------------------------- 
// - buildSettings:
// ---------------------------------------------------------- 
- (NSDictionary *) buildSettings
{
    return buildSettings; 
}

@end
