//
//  PBXFileReference.m
//  VerpackIt
//
//  Created by Uli Kusterer on 15.09.04.
//  Copyright 2004 M. Uli Kusterer. All rights reserved.
//

#import "PBXFileReference.h"
#import "PBXStringFromRefType.h"


@implementation PBXFileReference

-(id)	initWithObjData: (NSDictionary*)objData archive: (PBXArchive*)arc
{
	self = [super init];
	if( self )
	{
		objectData = [objData retain];

		explicitFileType = [[objData objectForKey: @"explicitFileType"] retain];
		path = [[objData objectForKey: @"path"] retain];
		sourceTree = [[objData objectForKey: @"sourceTree"] retain];
		refType = [[objData objectForKey: @"refType"] retain];
		includeInIndex = [[objData objectForKey: @"includeInIndex"] retain];
	}
	
	return self;
}


- (void) dealloc
{
    [objectData release];
    [explicitFileType release];
    [path release];
    [sourceTree release];
    [refType release];
    [includeInIndex release];

    objectData = nil;
    explicitFileType = nil;
    path = nil;
    sourceTree = nil;
    refType = nil;
    includeInIndex = nil;

    [super dealloc];
}


-(NSString*)	description
{
	return [NSString stringWithFormat: @"%@ { path = %@, explicitFileType = %@, refType = %@, sourceTree = %@, includeInIndex = %@ }",
						NSStringFromClass([self class]),
						path, explicitFileType, PBXStringFromRefType(refType), sourceTree, includeInIndex];
}


-(int)						count
{
	return 0;
}

-(id)	objectAtIndex: (int)n
{
	return nil;
}


// ---------------------------------------------------------- 
// - explicitFileType:
// ---------------------------------------------------------- 
- (NSString *) explicitFileType
{
    return explicitFileType; 
}

// ---------------------------------------------------------- 
// - path:
// ---------------------------------------------------------- 
- (NSString *) path
{
    return path; 
}

// ---------------------------------------------------------- 
// - sourceTree:
// ---------------------------------------------------------- 
- (NSString *) sourceTree
{
    return sourceTree; 
}

// ---------------------------------------------------------- 
// - refType:
// ---------------------------------------------------------- 
- (NSString *) refType
{
    return PBXStringFromRefType(refType); 
}

// ---------------------------------------------------------- 
// - includeInIndex:
// ---------------------------------------------------------- 
- (NSString *) includeInIndex
{
    return includeInIndex; 
}


@end
