//
//  PBXNativeTarget.m
//  VerpackIt
//
//  Created by Uli Kusterer on 15.09.04.
//  Copyright 2004 M. Uli Kusterer. All rights reserved.
//

#import "PBXNativeTarget.h"


@implementation PBXNativeTarget

-(id)	initWithObjData: (NSDictionary*)objData archive: (PBXArchive*)arc
{
	self = [super init];
	if( self )
	{
		objectData = [objData retain];
		buildPhases = [[NSMutableArray alloc] init];
		buildRules = [[NSMutableArray alloc] init];
		dependencies = [[NSMutableArray alloc] init];
		
		//NSLog(@"\n********** %@ **********\n%@\n ---------- %@ ----------\n", NSStringFromClass([self class]), objectData,NSStringFromClass([self class]));

		// Build Phases:
		NSEnumerator*	enny = [[objData objectForKey: @"buildPhases"] objectEnumerator];
		NSString*		objName;
		id				obj;
		
		while( (objName = [enny nextObject]) )
		{
			obj = [arc inflateObject: objName];
			if( obj ) [buildPhases addObject: obj];
		}
		
		// Build Rules:
		enny = [[objData objectForKey: @"buildRules"] objectEnumerator];
		
		while( (objName = [enny nextObject]) )
		{
			obj = [arc inflateObject: objName];
			if( obj ) [buildRules addObject: obj];
		}
		
		// Dependencies:
		enny = [[objData objectForKey: @"dependencies"] objectEnumerator];
		
		while( (objName = [enny nextObject]) )
		{
			obj = [arc inflateObject: objName];
			if( obj ) [dependencies addObject: obj];
		}
		
		// product reference:
		productReference = [[arc inflateObject: [objData objectForKey: @"productReference"]] retain];
		productType = [[objData objectForKey: @"productType"] retain];
		productInstallPath = [[objData objectForKey: @"productInstallPath"] retain];
		productName = [[objData objectForKey: @"productName"] retain];
		buildSettings = [[objData objectForKey: @"buildSettings"] retain];
		name = [[objData objectForKey: @"name"] retain];
		//NSLog(@"--------------------\n%@\n\n",buildSettings);
	}
	
	return self;
}


-(void) dealloc
{
	[objectData release];
	objectData = nil;

 	[name release];
	name = nil;
 
	[buildPhases release];
	buildPhases = nil;

	[buildSettings release];
	buildSettings = nil;

	[buildRules release];
	buildRules = nil;

	[dependencies release];
	dependencies = nil;

 	[productReference release];
	productReference = nil;

 	[productType release];
	productType = nil;

 	[productInstallPath release];
	productInstallPath = nil;

	[productName release];
	productName = nil;

   [super dealloc];
}

-(NSString*)	description
{
	return [NSString stringWithFormat: @"%@ { name = %@, productType = %@, productInstallPath = %@, productName = %@, buildSettings = %@ }",
						NSStringFromClass([self class]),
						name, productType, productInstallPath, productName, buildSettings];
}


-(int)						count
{
	return 1 +[buildPhases count] +[buildRules count] +[dependencies count];
}

-(id)	objectAtIndex: (int)n
{
	if( n == 0 )
		return productReference;
	else if( n <= [buildPhases count] )
		return [buildPhases objectAtIndex: (n -1)];
	else if( n <= ([buildPhases count] + [buildRules count]) )
		return [buildRules objectAtIndex: (n -1 -[buildPhases count])];
	else
		return [dependencies objectAtIndex: (n -1 -[buildPhases count] -[buildRules count])];
}


// ---------------------------------------------------------- 
// - productReference:
// ---------------------------------------------------------- 
- (id) productReference
{
    return productReference; 
}


// ---------------------------------------------------------- 
// - productType:
// ---------------------------------------------------------- 
- (NSString *) productType
{
    return productType; 
}


// ---------------------------------------------------------- 
// - productName:
// ---------------------------------------------------------- 
- (NSString *) productName
{
    return productName; 
}


// ---------------------------------------------------------- 
// - productInstallPath:
// ---------------------------------------------------------- 
- (NSString *) productInstallPath
{
    return productInstallPath; 
}


// ---------------------------------------------------------- 
// - name:
// ---------------------------------------------------------- 
- (NSString *) name
{
    return name; 
}

// ---------------------------------------------------------- 
// - buildSettings:
// ---------------------------------------------------------- 
- (NSDictionary *) buildSettings
{
    return buildSettings; 
}

@end
