//
//  PBXArchive.m
//  VerpackIt
//
//  Created by Uli Kusterer on 15.09.04.
//  Copyright 2004 M. Uli Kusterer. All rights reserved.
//

#import "PBXArchive.h"
#import "PBXDummyObject.h"


@implementation PBXArchive

-(id)			initWithDictionary: (NSDictionary*)pbxProjFile
					projectPath: (NSString*)projPath
{
	self = [super init];
	if( self )
	{
		fileDictionary = [pbxProjFile retain];
		archiveVersion = [[pbxProjFile objectForKey: @"archiveVersion"] retain];
		rootObject = [[self inflateObject: [pbxProjFile objectForKey: @"rootObject"]] retain];
		nameToObject = [[NSMutableDictionary alloc] init];
		projectPath = [projPath retain];
	}
	
	return self;
}

-(void)	dealloc
{
	[archiveVersion release];
	[(NSObject*)rootObject release];
	[fileDictionary release];
	[nameToObject release];
	[projectPath release];
	
	[super dealloc];
}


-(id)	inflateObject: (NSString*)nm
{
	NSDictionary*	objData = [[fileDictionary objectForKey: @"objects"] objectForKey: nm];
	NSString*		className = [objData objectForKey: @"isa"];
	Class			theClass = NSClassFromString( className );
	id				finalObj = [nameToObject objectForKey: nm];	// Look up whether we've already instantiated this.
	
	if( !objData )
		NSLog(@"Ooops. Object doesn't exist?");
	
	if( !finalObj )
	{
		if( !theClass )
		{
			className = [objData objectForKey: @"fallbackIsa"];
			if( className )
				theClass = NSClassFromString( className );
			if( !theClass )
				theClass = [PBXDummyObject class];
			else
				NSLog(@"PBXArchive: %@ not present, falling back on %@. objData = { %@ }\n\n",
						[objData objectForKey: @"isa"], className, objData);
		}
		finalObj = [[[theClass alloc] initWithObjData: objData archive: self] autorelease];
		[nameToObject setObject: finalObj forKey: nm];
	}
	else
		NSLog(@"*** File has multiple references to same object. ***\n\n");
	
	return finalObj;
}


-(NSString*)	projectFolderPath
{
	return [projectPath stringByDeletingLastPathComponent];
}

-(NSString*)	projectPath
{
	return projectPath;
}

-(NSString*)	buildProductPath
{
	return [[self projectFolderPath] stringByAppendingPathComponent: @"build"];
}


-(PBXProject*)	rootObject
{
	return rootObject;
}


-(NSString*)	description
{
	return [NSString stringWithFormat: @"PBXArchive { archiveVersion = %@ }", archiveVersion];
}


-(int)						count
{
	return 1;
}

-(id)	objectAtIndex: (int)n
{
	return rootObject;
}

@end
