//
//  PBXBuildFile.m
//  VerpackIt
//
//  Created by Uli Kusterer on 15.09.04.
//  Copyright 2004 M. Uli Kusterer. All rights reserved.
//

#import "PBXBuildFile.h"


@implementation PBXBuildFile

-(id)	initWithObjData: (NSDictionary*)objData archive: (PBXArchive*)arc
{
	self = [super init];
	if( self )
	{
		objectData = [objData retain];
		
		//NSLog(@"\n********** %@ **********\n%@\n ---------- %@ ----------\n", NSStringFromClass([self class]), objectData,NSStringFromClass([self class]));

		fileRef = [[arc inflateObject: [objData objectForKey: @"fileRef"]] retain];
		settings = [[objData objectForKey: @"settings"] retain];
	}
	
	return self;
}


- (void) dealloc
{
    [objectData release];
    [fileRef release];
    [settings release];

    objectData = nil;
    fileRef = nil;
    settings = nil;

    [super dealloc];
}


-(NSString*)	description
{
	return [NSString stringWithFormat: @"%@ { settings = %@ }",
						NSStringFromClass([self class]),
						settings];
}


-(int)						count
{
	return 1;
}

-(id)	objectAtIndex: (int)n
{
	return fileRef;
}

@end
