//
//  PBXGroup.m
//  VerpackIt
//
//  Created by Uli Kusterer on 15.09.04.
//  Copyright 2004 M. Uli Kusterer. All rights reserved.
//

#import "PBXGroup.h"
#import "PBXStringFromRefType.h"


@implementation PBXGroup

-(id)	initWithObjData: (NSDictionary*)objData archive: (PBXArchive*)arc
{
	self = [super init];
	if( self )
	{
		objectData = [objData retain];
		children = [[NSMutableArray alloc] init];
		
		//NSLog(@"\n********** %@ **********\n%@\n ---------- %@ ----------\n", NSStringFromClass([self class]), objectData,NSStringFromClass([self class]));

		// Children:
		NSEnumerator*	enny = [[objData objectForKey: @"children"] objectEnumerator];
		id				obj;
		NSString*		objName;
		
		while( (objName = [enny nextObject]) )
		{
			obj = [arc inflateObject: objName];
			if( obj ) [children addObject: obj];
		}
		
		// product reference:
		path = [[objData objectForKey: @"path"] retain];
		sourceTree = [[objData objectForKey: @"sourceTree"] retain];
		refType = [[objData objectForKey: @"refType"] retain];
		name = [[objData objectForKey: @"name"] retain];
	}
	
	return self;
}


- (void) dealloc
{
    [objectData release];
    [children release];
    [path release];
    [sourceTree release];
    [refType release];
    [name release];

    objectData = nil;
    children = nil;
    path = nil;
    sourceTree = nil;
    refType = nil;
    name = nil;

    [super dealloc];
}


-(NSString*)	description
{
	return [NSString stringWithFormat: @"%@ { name = %@, path = %@, refType = %@, sourceTree = %@ }",
						NSStringFromClass([self class]),
						name, path, PBXStringFromRefType(refType), sourceTree];
}


-(int)						count
{
	return [children count];
}

-(id)	objectAtIndex: (int)n
{
	return [children objectAtIndex: n];
}


// ---------------------------------------------------------- 
// - path:
// ---------------------------------------------------------- 
- (NSString *) path
{
    return path; 
}

// ---------------------------------------------------------- 
// - sourceTree:
// ---------------------------------------------------------- 
- (NSString *) sourceTree
{
    return sourceTree; 
}


// ---------------------------------------------------------- 
// - refType:
// ---------------------------------------------------------- 
- (NSString *) refType
{
    return PBXStringFromRefType(refType); 
}


// ---------------------------------------------------------- 
// - name:
// ---------------------------------------------------------- 
- (NSString *) name
{
    return name; 
}



@end
