//
//  PBXProject.m
//  VerpackIt
//
//  Created by Uli Kusterer on 15.09.04.
//  Copyright 2004 M. Uli Kusterer. All rights reserved.
//

#import "PBXProject.h"


@implementation PBXProject

-(id)	initWithObjData: (NSDictionary*)objData archive: (PBXArchive*)arc
{
	self = [super init];
	if( self )
	{
		buildStyles = [[NSMutableArray alloc] init];
		targets = [[NSMutableArray alloc] init];
		projectDirPath = [[objData objectForKey: @"projectDirPath"] retain];
		objectData = [objData retain];
		
		// Build Styles:
		NSEnumerator*	enny = [[objData objectForKey: @"buildStyles"] objectEnumerator];
		NSString*		objName;
		id				obj;
		
		while( (objName = [enny nextObject]) )
		{
			obj = [arc inflateObject: objName];
			if( obj ) [buildStyles addObject: obj];
		}
		
		// Targets:
		enny = [[objData objectForKey: @"targets"] objectEnumerator];
		
		while( (objName = [enny nextObject]) )
		{
			obj = [arc inflateObject: objName];
			if( obj ) [targets addObject: obj];
		}
		
		mainGroup = [[arc inflateObject: [objData objectForKey: @"mainGroup"]] retain];
	}
	
	return self;
}


-(void) dealloc
{
    [projectDirPath release];
    [buildStyles release];
    [targets release];
    [(NSObject*)mainGroup release];
	[objectData release];

    projectDirPath = nil;
    buildStyles = nil;
    targets = nil;
    mainGroup = nil;
	objectData = nil;

    [super dealloc];
}


-(PBXGroup*)	mainGroup
{
	return mainGroup;
}


-(NSString*)	description
{
	return [NSString stringWithFormat: @"PBXProject { projectDirPath = %@ }", projectDirPath];
}


-(int)						count
{
	return 1 +[buildStyles count] +[targets count];
}

-(id)	objectAtIndex: (int)n
{
	if( n == 0 )
		return mainGroup;
	else if( n <= [buildStyles count] )
		return [buildStyles objectAtIndex: (n -1)];
	else
		return [targets objectAtIndex: (n -1 -[buildStyles count])];
}


-(int)				buildStyleCount
{
	return [buildStyles count];
}


-(PBXBuildStyle*)	buildStyleAtIndex: (int)n
{
	return [buildStyles objectAtIndex: n];
}


-(int)				targetCount
{
	return [targets count];
}


-(PBXNativeTarget*)	targetAtIndex: (int)n
{
	return [targets objectAtIndex: n];
}



@end
